/****** Object:  Trigger [TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA]    Script Date: 21/07/2014 14:34:01 ******/
IF EXISTS(SELECT NAME FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA')
BEGIN
	DROP TRIGGER [dbo].[TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA]
END
GO
GO
-------------------------------------ALTERACAO EM EST_PED_VD--------------------------------------
CREATE TRIGGER [dbo].[TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA] ON [dbo].[EST_PED_VD] FOR UPDATE AS
IF UPDATE (UUID)
BEGIN
	RETURN;
END
--Proibe alteracao na nota fiscal de saida quando ja existe registro da transferencia
IF EXISTS (SELECT * FROM EST_NF_SAI_PED_VD t INNER JOIN DELETED s 
				ON t.CD_FILIAL=s.CD_FILIAL AND t.CD_EMP=s.CD_EMP AND t.CD_PED=s.CD_PED)
  begin
	IF NOT UPDATE(STS_PED) 
		begin
			RAISERROR ('Nao pode haver alteracao do pedido quando emitido nota fiscal de saida.',16, 1);
			ROLLBACK TRANSACTION;
			RETURN;
		end

	IF UPDATE(CD_CLI)   --Proibe alteracao no codigo do cliente
	  begin
		RAISERROR ('Nao pode haver alteracao do pedido quando emitido nota fiscal de saida',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end 
  end 
  
--Verifica se alterou campos que podem criar condicoes para entrada ou saida na pendencia de entrada
  begin
	--Pendencia de entrada pre-faturas transferencias (SEPARADO NO ESTOQUE)
	INSERT INTO EST_PED_VD_PENDENCIA (
			CD_EMP, 
			CD_FILIAL, 
			CD_PED, 
			CD_FILIAL_DEST,
			FLAG_REALIZAR_FAT)
		SELECT 
			p.CD_EMP, 
			p.CD_FILIAL, 
			p.CD_PED, 
			CASE WHEN O.DEST_ORIG=2 THEN
			 P.CD_CLI
		ELSE 
			ISNULL(PRC_FILIAL_RC_CLI.CD_FILIAL, P.CD_CLI) END CD_DEST,
			ISNULL(p.FLAG_REALIZAR_FAT,0)
		FROM 
			INSERTED p LEFT OUTER JOIN PRC_FILIAL_RC_CLI ON
			p.CD_EMP = PRC_FILIAL_RC_CLI.CD_EMP AND
			p.CD_CLI = PRC_FILIAL_RC_CLI.CD_CLI
			
			INNER JOIN GLB_MOV_OP O ON
			P.CD_NT_MOV = O.CD_MOV_OP
			
		WHERE 
			p.STS_PED <> 2
			AND NOT EXISTS (SELECT 
								* 
							FROM 
								EST_NF_SAI_PED_VD
						  WHERE 
								p.CD_EMP=CD_EMP AND 
								p.CD_FILIAL=CD_FILIAL AND 
								p.CD_PED=CD_PED)
			AND NOT EXISTS (SELECT 
								* 
							FROM 
								EST_NF_ENT_PED_VD
						  WHERE 
								p.CD_EMP=CD_EMP AND 
								p.CD_FILIAL=CD_FILIAL AND 
								p.CD_PED=CD_PED)
			AND NOT EXISTS (SELECT 
								* 
							FROM 
								EST_PROD_REQ_TRANSF_LIB_EST_PED_VD
							WHERE 
								p.CD_EMP=CD_EMP AND 
								p.CD_FILIAL=CD_FILIAL AND 
								p.CD_PED=CD_PED)
          AND NOT EXISTS (SELECT 
								* 
						  FROM 
								EST_PED_VD_PENDENCIA
                          WHERE 
								CD_FILIAL=p.CD_FILIAL AND 
								CD_EMP=p.CD_EMP AND 
								CD_PED=p.CD_PED);
    DELETE FROM f     ---->estava na tabela de trabalho e perdeu uma das condicoes
        FROM 
			EST_PED_VD_PENDENCIA f INNER JOIN INSERTED s ON 
			f.CD_FILIAL=s.CD_FILIAL AND 
			f.CD_EMP=s.CD_EMP AND 
			f.CD_PED=s.CD_PED
        WHERE 
			s.STS_PED=2
	
    DELETE FROM f     ---->estava na tabela de trabalho erros de validacao
        FROM 
			EST_PED_VD_ERROS_VALIDACAO f INNER JOIN INSERTED s ON 
			f.CD_FILIAL=s.CD_FILIAL AND 
			f.CD_EMP=s.CD_EMP AND 
			f.CD_PED=s.CD_PED
        WHERE 
			s.STS_PED=2
  end